 ; Ŀ
 ;   Qqq - save a drawing.                                                 
 ;   Copyright 1991, 2006 by Rocket Software Ltd.                          
 ;   Includes the nice shrinking screen outline routine Bo.                
 ; 

 ; Ŀ
 ;   Bo, the box maker.                                                    
 ; 
 (defun bo (/ a vs ctr w maxx minx maxy miny incra pa pax pay ldis rdis
                                                                tdis bdis)
  (setq a (getvar "screensize"))           ; view height & width (pixels)
  (setq a (/ (car a) (cadr a)))            ; view width/height ratio
  (setq vs (* (getvar "viewsize") 0.5))    ; view height in drawing units
  (setq ctr (getvar "viewctr"))            ; centre point of screen
  (setq w (* vs a ))                       ; view half width
  (setq maxx (+ (car ctr) w))
  (setq minx (- (car ctr) w))
  (setq maxy (+ (cadr ctr) vs))
  (setq miny (- (cadr ctr) vs))
  (setq incra 1000)
  (setq pa (cadr (grread t)))
  (setq pax (car pa))
  (setq pay (cadr pa))
  (setq ldis (/ (- pax minx) incra))
  (setq rdis (/ (- maxx pax) incra))
  (setq tdis (/ (- maxy pay) incra))
  (setq bdis (/ (- pay miny) incra))
  (repeat incra
         (fungo minx maxx miny maxy)
         (setq minx (+ minx ldis))
         (setq maxx (- maxx rdis))
         (setq miny (+ miny bdis))
         (setq maxy (- maxy tdis)))
 (princ))
 ; Ŀ
 ;   Bo end.                                                               
 ; 

 ; Ŀ
 ;   Fungo, draw and undraw a box from a maximum and minimum x and y.      
 ; 
 (defun fungo (minx maxx miny maxy / ll ul ul lr)
  (setq ll (list minx miny))
  (setq ul (list minx maxy))
  (setq ur (list maxx maxy))
  (setq lr (list maxx miny))
  (repeat 2
   (grdraw ll ul -1)
   (grdraw ul ur -1)
   (grdraw ur lr -1)
   (grdraw lr ll -1))
 (princ))
 ; Ŀ
 ;   Fungo end.                                                            
 ; 

 ; Ŀ
 ;   Qqq.                                                                  
 ; 
 (DEFUN C:QQQ ()
  (setvar "cmdecho" 0)
  (command ".qsave")
  (bo)
 (princ))